﻿using System;
using System.Runtime.Serialization;

namespace VA.PPMS.IWS.Common
{
    [DataContract]
    public sealed class Validation : IComparable<string>
    {
        [DataMember]
        private string _errorSource;

        public Validation(string providerId, string correlationId, string providerName, int transactionType, string result)
        {
            ProviderId = providerId;
            CorrelationId = correlationId;
            ProviderName = providerName;
            TransactionType = transactionType;
            Result = result;
        }

        [DataMember]
        public string ProviderId { get; set; }

        [DataMember]
        public string CorrelationId { get; set; }

        [DataMember]
        public string ProviderName { get; set; }

        [DataMember]
        public int TransactionType { get; set; }

        [DataMember]
        public string Result { get; set; }

        public int CompareTo(string other)
        {
            return string.IsNullOrEmpty(other) ? 1 : string.Compare(ProviderId, other, StringComparison.Ordinal);
        }

        public bool IsValid => string.IsNullOrEmpty(Result);

        public string ErrorSource
        {
            get => string.IsNullOrEmpty(_errorSource) ? "Provider" : _errorSource;
            set => _errorSource = value;
        }
    }
}